/*
 * Decompiled with CFR 0.152.
 */
package com.deokma.MoltenVents.block.entity;

import com.deokma.MoltenVents.block.entity.MoltenBlockEntities;
import com.deokma.MoltenVents.config.CommonConfig;
import com.deokma.MoltenVents.core.MoltenVentsConductiveData;
import com.deokma.MoltenVents.core.MoltenVentsConvertibleData;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7923;

public class ActiveMoltenBlockEntity
extends class_2586 {
    private static final Map<class_2960, JsonElement> conductiveMap = MoltenVentsConductiveData.conductiveBlocksMap;
    private static final Map<class_2960, JsonElement> convertibleMap = MoltenVentsConvertibleData.convertibleBlocksMap;
    public static int spreadDistance = 5;

    public ActiveMoltenBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ActiveMoltenBlockEntity.activeMoltenBlockEntity(blockState), blockPos, blockState);
    }

    private static class_2591<?> activeMoltenBlockEntity(class_2680 blockState) {
        List<Map<class_2248, class_2591<?>>> moltenBlockEntities = MoltenBlockEntities.getMoltenBlockEntities();
        class_2591<?> activeMoltenBlockEntity = null;
        for (int i = 0; i < moltenBlockEntities.size(); ++i) {
            class_2591<?> activeBlockEntity = moltenBlockEntities.get(i).get(blockState.method_26204());
            if (activeBlockEntity == null) continue;
            activeMoltenBlockEntity = activeBlockEntity;
        }
        return activeMoltenBlockEntity;
    }

    private static Map<Integer, List<class_2248>> getLists(class_2680 blockState) {
        String name = class_7923.field_41175.method_10221((Object)blockState.method_26204()).method_12832().substring(14);
        ArrayList<class_2248> conductiveBlocks = new ArrayList<class_2248>(List.of());
        ArrayList<class_2248> convertibleBlocks = new ArrayList<class_2248>(List.of());
        JsonElement conductiveElement = conductiveMap.get(new class_2960("molten_vents", "molten_vents/blocks/conductive/" + name + ".json"));
        if (conductiveElement == null || !conductiveElement.isJsonObject()) {
            System.out.println("Error: missing data for block " + name);
            return Map.of(1, List.of(), 2, List.of());
        }
        JsonArray conductiveList = conductiveElement.getAsJsonObject().getAsJsonArray("values");
        for (int i = 0; i < conductiveList.size(); ++i) {
            JsonElement blockName = conductiveList.get(i);
            conductiveBlocks.add((class_2248)class_7923.field_41175.method_10223(new class_2960(blockName.toString().substring(1, blockName.toString().length() - 1))));
        }
        JsonElement convertibleElement = convertibleMap.get(new class_2960("molten_vents", "molten_vents/blocks/convertible/" + name + ".json"));
        if (convertibleElement == null || !convertibleElement.isJsonObject()) {
            System.out.println("Error: missing data for block " + name);
            return Map.of(1, List.of(), 2, List.of());
        }
        JsonArray convertibleList = convertibleElement.getAsJsonObject().getAsJsonArray("values");
        for (int i = 0; i < convertibleList.size(); ++i) {
            JsonElement blockName = convertibleList.get(i);
            convertibleBlocks.add((class_2248)class_7923.field_41175.method_10223(new class_2960(blockName.toString().substring(1, blockName.toString().length() - 1))));
        }
        return Map.of(1, conductiveBlocks, 2, convertibleBlocks);
    }

    public static <T extends class_2586> void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, T t) {
        if (!level.field_9236) {
            class_3218 serverLevel = Objects.requireNonNull(level.method_8503()).method_3847(level.method_27983());
            Map<Integer, List<class_2248>> lists = ActiveMoltenBlockEntity.getLists(blockState);
            List<class_2248> conductiveBlocks = lists.get(1);
            List<class_2248> convertibleBlocks = lists.get(2);
            ActiveMoltenBlockEntity.spreadBlock(conductiveBlocks, convertibleBlocks, blockPos.method_10084(), serverLevel);
            ActiveMoltenBlockEntity.spreadBlock(conductiveBlocks, convertibleBlocks, blockPos.method_10074(), serverLevel);
            ActiveMoltenBlockEntity.spreadBlock(conductiveBlocks, convertibleBlocks, blockPos.method_10095(), serverLevel);
            ActiveMoltenBlockEntity.spreadBlock(conductiveBlocks, convertibleBlocks, blockPos.method_10078(), serverLevel);
            ActiveMoltenBlockEntity.spreadBlock(conductiveBlocks, convertibleBlocks, blockPos.method_10072(), serverLevel);
            ActiveMoltenBlockEntity.spreadBlock(conductiveBlocks, convertibleBlocks, blockPos.method_10067(), serverLevel);
        }
    }

    private static void spreadBlock(List<class_2248> conductiveBlocks, List<class_2248> convertibleBlocks, class_2338 pos, class_3218 serverWorld) {
        class_2680[] contacts = new class_2680[]{serverWorld.method_8320(pos.method_10084()), serverWorld.method_8320(pos.method_10074()), serverWorld.method_8320(pos.method_10095()), serverWorld.method_8320(pos.method_10078()), serverWorld.method_8320(pos.method_10072()), serverWorld.method_8320(pos.method_10067())};
        Boolean isTouchingOrestone = false;
        for (int i = 0; i < contacts.length && !isTouchingOrestone.booleanValue(); ++i) {
            if (!conductiveBlocks.contains(contacts[i].method_26204())) continue;
            isTouchingOrestone = true;
        }
        if (isTouchingOrestone != false && !serverWorld.method_8320(pos).method_51176() && convertibleBlocks.contains(serverWorld.method_8320(pos).method_26204()) || isTouchingOrestone != false && !CommonConfig.get().useSource && convertibleBlocks.contains(serverWorld.method_8320(pos).method_26204()) || isTouchingOrestone != false && CommonConfig.get().useSource && convertibleBlocks.contains(serverWorld.method_8320(pos).method_26204()) && serverWorld.method_8320(pos).method_26227().method_15771() || isTouchingOrestone.booleanValue() && conductiveBlocks.contains(serverWorld.method_8320(pos).method_26204())) {
            List<class_2338> convertedBlocks;
            if (!serverWorld.method_8320(pos).method_51176() && convertibleBlocks.contains(serverWorld.method_8320(pos).method_26204()) || !CommonConfig.get().useSource && convertibleBlocks.contains(serverWorld.method_8320(pos).method_26204()) || CommonConfig.get().useSource && convertibleBlocks.contains(serverWorld.method_8320(pos).method_26204()) && serverWorld.method_8320(pos).method_26227().method_15771()) {
                serverWorld.method_8652(pos, conductiveBlocks.get(0).method_9564(), 3);
                serverWorld.method_8396(null, pos, class_3417.field_19198, class_3419.field_15245, 1.0f, 1.0f);
                serverWorld.method_8503().method_3847(serverWorld.method_27983()).method_14199((class_2394)class_2398.field_11237, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.25, (double)pos.method_10260() + 0.5, 8, 0.5, 0.25, 0.5, 0.0);
            }
            if ((convertedBlocks = ActiveMoltenBlockEntity.convertTouching(convertibleBlocks, conductiveBlocks, pos, serverWorld)) != null && !convertedBlocks.isEmpty() && spreadDistance >= 1) {
                ArrayList<class_2338> secondaryConvertedBlocks = new ArrayList<class_2338>(List.of());
                for (int i = 0; i < convertedBlocks.size(); ++i) {
                    List<class_2338> minorConvertedBlocks = ActiveMoltenBlockEntity.convertTouching(convertibleBlocks, conductiveBlocks, convertedBlocks.get(i), serverWorld);
                    if (minorConvertedBlocks == null || !minorConvertedBlocks.isEmpty()) continue;
                    secondaryConvertedBlocks.addAll(minorConvertedBlocks);
                }
                if (secondaryConvertedBlocks != null && !secondaryConvertedBlocks.isEmpty() && spreadDistance >= 2) {
                    ArrayList<class_2338> teritaryConvertedBlocks = new ArrayList<class_2338>(List.of());
                    for (int i = 0; i < secondaryConvertedBlocks.size(); ++i) {
                        List<class_2338> minorConvertedBlocks = ActiveMoltenBlockEntity.convertTouching(convertibleBlocks, conductiveBlocks, (class_2338)secondaryConvertedBlocks.get(i), serverWorld);
                        if (minorConvertedBlocks == null || !minorConvertedBlocks.isEmpty()) continue;
                        teritaryConvertedBlocks.addAll(minorConvertedBlocks);
                    }
                    if (teritaryConvertedBlocks != null && !teritaryConvertedBlocks.isEmpty() && spreadDistance >= 3) {
                        ArrayList<class_2338> quaternaryConvertedBlocks = new ArrayList<class_2338>(List.of());
                        for (int i = 0; i < teritaryConvertedBlocks.size(); ++i) {
                            List<class_2338> minorConvertedBlocks = ActiveMoltenBlockEntity.convertTouching(convertibleBlocks, conductiveBlocks, (class_2338)teritaryConvertedBlocks.get(i), serverWorld);
                            if (minorConvertedBlocks == null || !minorConvertedBlocks.isEmpty()) continue;
                            quaternaryConvertedBlocks.addAll(minorConvertedBlocks);
                        }
                        if (quaternaryConvertedBlocks != null && !quaternaryConvertedBlocks.isEmpty() && spreadDistance >= 4) {
                            ArrayList<class_2338> quinaryConvertedBlocks = new ArrayList<class_2338>(List.of());
                            for (int i = 0; i < quaternaryConvertedBlocks.size(); ++i) {
                                List<class_2338> minorConvertedBlocks = ActiveMoltenBlockEntity.convertTouching(convertibleBlocks, conductiveBlocks, (class_2338)quaternaryConvertedBlocks.get(i), serverWorld);
                                if (minorConvertedBlocks == null || !minorConvertedBlocks.isEmpty()) continue;
                                quinaryConvertedBlocks.addAll(minorConvertedBlocks);
                            }
                            if (quinaryConvertedBlocks != null && !quinaryConvertedBlocks.isEmpty() && spreadDistance >= 5) {
                                ArrayList<class_2338> senaryConvertedBlocks = new ArrayList<class_2338>(List.of());
                                for (int i = 0; i < quinaryConvertedBlocks.size(); ++i) {
                                    List<class_2338> minorConvertedBlocks = ActiveMoltenBlockEntity.convertTouching(convertibleBlocks, conductiveBlocks, (class_2338)quinaryConvertedBlocks.get(i), serverWorld);
                                    if (minorConvertedBlocks == null || !minorConvertedBlocks.isEmpty()) continue;
                                    senaryConvertedBlocks.addAll(minorConvertedBlocks);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private static List<class_2338> convertTouching(List<class_2248> convertibleBlocks, List<class_2248> conductiveBlocks, class_2338 pos, class_3218 level) {
        List<class_2338> lavaBlocks = ActiveMoltenBlockEntity.getLavaTouching(convertibleBlocks, pos, (class_1937)level);
        List<class_2338> touchingBlocks = ActiveMoltenBlockEntity.getLavaTouching(conductiveBlocks, pos, (class_1937)level);
        if (lavaBlocks != null && !lavaBlocks.isEmpty()) {
            for (int i = 0; i < lavaBlocks.size(); ++i) {
                class_2338 lavaPos = lavaBlocks.get(i);
                if (!(!level.method_8320(lavaPos).method_51176() && convertibleBlocks.contains(level.method_8320(lavaPos).method_26204()) || !CommonConfig.get().useSource && convertibleBlocks.contains(level.method_8320(lavaPos).method_26204())) && (!CommonConfig.get().useSource || !convertibleBlocks.contains(level.method_8320(lavaPos).method_26204()) || !level.method_8320(lavaPos).method_26227().method_15771())) continue;
                level.method_8652(lavaPos, conductiveBlocks.get(0).method_9564(), 3);
                level.method_8396(null, lavaPos, class_3417.field_19198, class_3419.field_15245, 1.0f, 1.0f);
                level.method_8503().method_3847(level.method_27983()).method_14199((class_2394)class_2398.field_11237, (double)lavaPos.method_10263() + 0.5, (double)lavaPos.method_10264() + 0.25, (double)lavaPos.method_10260() + 0.5, 8, 0.5, 0.25, 0.5, 0.0);
            }
        }
        if (touchingBlocks.size() > 0) {
            return touchingBlocks;
        }
        return null;
    }

    private static List<class_2338> getLavaTouching(List<class_2248> convertibleBlocks, class_2338 pos, class_1937 level) {
        class_2338[] contacts = new class_2338[]{pos.method_10084(), pos.method_10074(), pos.method_10095(), pos.method_10078(), pos.method_10072(), pos.method_10067()};
        ArrayList<class_2338> lavaBlocks = new ArrayList<class_2338>(List.of());
        for (int i = 0; i < contacts.length; ++i) {
            if (!(!level.method_8320(contacts[i]).method_51176() && convertibleBlocks.contains(level.method_8320(contacts[i]).method_26204()) || !CommonConfig.get().useSource && convertibleBlocks.contains(level.method_8320(contacts[i]).method_26204()) || CommonConfig.get().useSource && convertibleBlocks.contains(level.method_8320(contacts[i]).method_26204()) && level.method_8320(contacts[i]).method_26227().method_15771()) && !convertibleBlocks.contains(level.method_8320(contacts[i]).method_26204())) continue;
            lavaBlocks.add(contacts[i]);
        }
        if (!lavaBlocks.isEmpty()) {
            return lavaBlocks;
        }
        return null;
    }
}

